rm(list=objects())
setwd("~/Desktop/Experiments/Simulations/Results")

type <- 1
path <- "Fixed K"

# Load results
if(type == 1){
  path <- paste0(path, "/Assortative SBM")
}else if(type == 2){
  path <- paste0(path, "/Disassortative SBM")
}else{
  path <- paste0(path, "/Mixed SBM")
}


N_list <- round(exp(seq(log(50), log(1000), length.out = 10)))
M <- 100 # number of experiments

# record the errors 
Error_missSBM <- matrix(NA, ncol = 3, nrow = 10)
Error_Var <- matrix(NA, ncol = 3, nrow = 10)
Error_true_Z <- matrix(NA, ncol = 3, nrow = 10)
Error_softImpute <- matrix(NA, ncol = 3, nrow = 10)

for (n in 1:10){
  N <- N_list[n]
  res <- readRDS(paste0(path, "/N_", N,".RDS"))
  Error_missSBM[n,] <- quantile(res$Error_missSBM, probs = c(0.25, 0.5, 0.75))
  Error_Var[n,] <- quantile(res$Error_Var, probs = c(0.25, 0.5, 0.75))
  Error_softImpute[n,] <- quantile(res$Error_softImpute, probs = c(0.25, 0.5, 0.75))
  Error_true_Z[n,] <- quantile(res$Error_true_Z, probs = c(0.25, 0.5, 0.75))
}


plot(x = N_list, y = Error_softImpute[,2], type = 'l', col = 'green', 
      xlab = "Number of nodes", ylab = "Error", log = "x", ylim = c(0,0.08))
lines(x = N_list, y = Error_softImpute[,1], lty = 3, col = 'green')
lines(x = N_list, y = Error_softImpute[,3], lty = 3, col = 'green')

lines(x = N_list, y = Error_true_Z[,2], col = 'black')
lines(x = N_list, y = Error_true_Z[,1], lty = 3, col = 'black')
lines(x = N_list, y = Error_true_Z[,3], lty = 3, col = 'black')

lines(x = N_list, y = Error_Var[,2], col = 'blue')
lines(x = N_list, y = Error_Var[,1], lty = 3, col = 'blue')
lines(x = N_list, y = Error_Var[,3], lty = 3, col = 'blue')

lines(x = N_list, y = Error_missSBM[,2], col = 'red')
lines(x = N_list, y = Error_missSBM[,1], lty = 3, col = 'red')
lines(x = N_list, y = Error_missSBM[,3], lty = 3, col = 'red')

